/*
**  wsc.h
**
**  Use for both Win16 & Win32.
*/

#ifdef WIN32
  #ifdef _MSC_VER
     #define DLLEXPORT __stdcall
  #else
     #define DLLEXPORT __stdcall _export
  #endif
#else
  #define DLLEXPORT FAR PASCAL
#endif

#ifdef __cplusplus
  #define NoMangle extern "C"
#else
  #define NoMangle
#endif

NoMangle int DLLEXPORT SioBaud(int,unsigned);
NoMangle int DLLEXPORT SioBrkSig(int,char);
NoMangle int DLLEXPORT SioCTS(int);
NoMangle int DLLEXPORT SioDCD(int);
NoMangle int DLLEXPORT SioDebug(int);
NoMangle int DLLEXPORT SioDone(int);
NoMangle int DLLEXPORT SioDSR(int);
NoMangle int DLLEXPORT SioDTR(int,char);
NoMangle int DLLEXPORT SioFlow(int,char);
NoMangle int DLLEXPORT SioInfo(char);
NoMangle int DLLEXPORT SioGetc(int);
NoMangle int DLLEXPORT SioGets(int,LPSTR,unsigned);
NoMangle int DLLEXPORT SioParms(int,int,int,int);
NoMangle int DLLEXPORT SioPutc(int,char);
NoMangle int DLLEXPORT SioPuts(int,LPSTR,unsigned);
NoMangle int DLLEXPORT SioRead(int,int);
NoMangle int DLLEXPORT SioReset(int,int,int);
NoMangle int DLLEXPORT SioRI(int);
NoMangle int DLLEXPORT SioRTS(int,char);
NoMangle int DLLEXPORT SioRxClear(int);
NoMangle int DLLEXPORT SioRxQue(int);
NoMangle int DLLEXPORT SioStatus(int,unsigned);
NoMangle int DLLEXPORT SioTxClear(int);
NoMangle int DLLEXPORT SioTxQue(int);
NoMangle int DLLEXPORT SioUnGetc(int,char);
NoMangle int DLLEXPORT SioWinError(void);

#define COM1   0
#define COM2   1
#define COM3   2
#define COM4   3
#define COM5   4
#define COM6   5
#define COM7   6
#define COM8   7
#define COM9   8

/* Parity Codes */

#define NoParity 0
#define OddParity  1
#define EvenParity 2
#define MarkParity 3
#define SpaceParity 4

/* Stop Bit Codes */

#define OneStopBit  0
#define TwoStopBits 2

/* Word Length Codes */

#define WordLength5  5
#define WordLength6  6
#define WordLength7  7
#define WordLength8  8

/* return codes */

#define WSC_NO_DATA   (-100)
#define WSC_RANGE     (-101)
#define WSC_ABORTED   (-102)
#define WSC_WIN32ERR  (-103)
#define WSC_EXPIRED   (-104)
#define IE_BADID      (-1)
#define IE_OPEN       (-2)
#define IE_NOPEN      (-3)
#define IE_MEMORY     (-4)
#define IE_DEFAULT    (-5)
#define IE_HARDWARE   (-10)
#define IE_BYTESIZE   (-11)
#define IE_BAUDRATE   (-12)

/* baud codes */

#define Baud110    0
#define Baud300    1
#define Baud1200   2
#define Baud2400   3
#define Baud4800   4
#define Baud9600   5
#define Baud19200  6
#define Baud38400  7
#define Baud57600  8
#define Baud115200 9

/* SioGetError masks */

#define WSC_RXOVER   0x0001
#define WSC_OVERRUN  0x0002
#define WSC_PARITY   0x0004
#define WSC_FRAME    0x0008
#define WSC_BREAK    0x0010
#define WSC_TXFULL   0x0100
























































































  
